const express = require("express");
const router = express.Router();
const doctorContoller = require("../controllers/doctor");

router.get("/doctors", doctorContoller.getDoctors);
router.post("/doctors/book", doctorContoller.bookDoctor);
router.post("/doctors/sendotp", doctorContoller.sendotp);
router.post("/doctors/otpverify", doctorContoller.otpverify);
router.post("/doctors/preceptionupdate", doctorContoller.preceptionupdate);
router.post("/doctors/preception", doctorContoller.preceptionpdf);
router.post("/doctorregister", doctorContoller.doctorregister);
router.post("/checkdoctorexist", doctorContoller.checkdoctorexist);
router.post("/doctorstatusupdate", doctorContoller.doctorstatusupdate);
router.post("/doctorbankdetailsupdate", doctorContoller.doctorbankdetailsupdate);
router.post("/doctordeviceidupdate", doctorContoller.doctordeviceidupdate);
router.post("/previoususerprecription", doctorContoller.previoususerprecription);
router.get("/doctorsms", doctorContoller.doctorsms);

module.exports = router;
