const mongoose = require("mongoose");
const Schema = mongoose.Schema;

const subOrder = new Schema(
  {
    id: {
      type: String,
      required: true,
    },
    name: {
      type: String,
      required: true,
    },
    price: {
      type: String,
      required: true,
    },
    type: {
      type: String,
      required: true,
    },
    bookedAt: {
      type: Date,
    },
  },
  { timestamps: true }
);


const doctorsubOrder = new Schema(
  {
    id: {
      type: String,
      required: true,
    },
    name: {
      type: String,
      required: true,
    },
    price: {
      type: String,
      required: true,
    },
    type: {
      type: String,
	  required: true,
    },
	remarks: {
      type: String,
    },
	primaryhealthissue: {
      type: String,
    },
	preferredlanguage: {
      type: String,
    },
	modeofservice: {
      type: String,
    },
	symptoms: {
      type: Array,
    },
	postalcode: {
      type: String,
    },
	address: {
      type: String,
    },
	long: {
      type: String,
    },
	lat: {
      type: String,
    },
	status: {
      type: String,
    },
    medicine: {
      type: Array,
    },
	 test: {
      type: Array,
    },
	 diagnosis: {
      type: Array,
    },
	 hospitalised: {
      type: String,
    },
	 specialist: {
      type: Array,
    }, wellness: {
      type: Array,
    },
	 remark: {
      type: String,
    },
	 findings: {
      type: Array,
    },
	 followupdate: {
      type: String,
    },
	 doctorcheckdate: {
      type: String,
    },
	 doctorfeedback: {
      type: String,
    },
	pdffile: {
      type: String,
    },
  },
  { timestamps: true }
);

const order = new Schema(
  {
    userId: {
       type: mongoose.Types.ObjectId,
       ref: 'member'
    },
	doctorId: {
      type: String,
      required: true,
    },
	doctorscheckup: {
      type: Array,
      required: true,
    },
    items: {
      type: Array,
    },
	 usercheckup: {
      type: Array,
    },
    doctors: [doctorsubOrder],
    healthAssists: [subOrder],
  },
  { timestamps: true }
);

module.exports = mongoose.model("Order", order);
