const mongoose = require("mongoose");
const Schema = mongoose.Schema;

const memberSchema = new Schema(
  {
    id: {
      type: String,
    },
    name: {
      type: String,
      required: true,
    },
    cityId: {
      type: String,
      required: true,
    },
    pincode: {
      type: Number,
      required: true,
    },
    gender: {
      type: String,
      required: true,
    },
    dob: {
      type: String,
      required: true,
    },
    mobile: {
      type: Number,
      required: true,
    },
    password: {
      type: String,
    },
    dateOfJoining: {
      type: String,
    },
    employeeTag: {
      type: String,
    },
    employeeId: {
      type: Number,
    },
    groupId: {
      type: String,
    },
    relation: {
      type: String,
    },
    email: {
      type: String,
      required: true,
    },
    renewalFlag: {
      type: String,
    },
    activeFlag: {
      type: String,
    },
    activePlanId: {
      type: String,
    },
	food_habit: {
      type: String,
    },
	address: {
      type: String,
    },
	height: {
      type: String,
    },
	weight: {
      type: String,
    },
	blood_group: {
      type: String,
    },
	occupation: {
      type: String,
    },
	lifestyle: {
      type: String,
    },
	exercise_flag: {
      type: String,
    },
	water_intake_daily: {
      type: String,
    },
	activePlanId: {
      type: String,
    },
	medical_history: {
      type: String,
    },
	sick_frequently: {
      type: String,
    },
	picture: {
      type: String,
    },
	documentfiles: {
      type: String,
    },
	meals_per_day: {
      type: String,
    },
	preferred_mode_of_treatment: {
      type: String,
    },
	remark: {
      type: String,
    },
	
  },
  { timestamps: true }
);

module.exports = mongoose.model("Member", memberSchema);
