const mongoose = require("mongoose");
const Schema = mongoose.Schema;

const doctorSchema = new Schema(
  {
    id: {
      type: Number,
    },
    name: {
      type: String,
      required: true,
    },
	registrationno: {
      type: String,
    },
	dob: {
      type: String,
    },
	gender: {
      type: String,
    },
	clinicname: {
      type: String,
    },
	address: {
      type: String,
    },
	workingto: {
      type: String,
    },
	workingfrom: {
      type: String,
    },
	practice: {
      type: String,
    },
	signature: {
      type: String,
    },
    qualification: {
      type: String, 
    },
    specialization: {
      type: String,
    },
    experience: {
      type: Number,
    },
    treatmentType: {
      type: String,
    },
    picture: {
      type: String,
    },
    cityId: {
      type: String,
    },
    pincode: {
      type: Number,
    },
    email: {
      type: String,
      required: true,
    },
    mobile: {
      type: Number,
      required: true,
    },
	otp: {
      type: Number,
    },
	otpstatus: {
      type: Number,
    },
	latitude: {
      type: String,
    },
	longitude: {
      type: String,
    },
	modeofservices: {
      type: String,
    },
	documentfiles: {
      type: String,
    },
	loggedintime: {
      type: Number,
    },
    fromTime: {
      type: String,
    },
    toTime: {
      type: String,
    },
	status: {
      type: String,
    },
	statusservices: {
      type: Array,
    },
	accountname: {
      type: String,
    },
	accountnumber: {
       type: String,
    },
	ifsccode: {
      type: String,
    },
	upipin: {
       type: String,
    },
	deviceid: {
       type: String,
    },
	accrediation: {
       type: Array,
    },
	specialities: {
       type: Array,
    },
	language: {
       type: Array,
    },
	facility: {
       type: Array,
    },
  },
  { timestamps: true }
);

module.exports = mongoose.model("Doctor", doctorSchema);
