const mongoose = require("mongoose");
const Schema = mongoose.Schema;

const diagnosis = new Schema(
  {
    icd_code: {
      type: String,
      required: true,
    },
    diagnosis_name: {
      type: String,
      required: true,
    },
    description: {
      type: String,
      required: true,
    },
    avg_days_of_cure: {
      type: String,
      required: true,
    },
    specialist_code: {
      type: String,
      required: true,
    },
    side_effects: {
      type: String,
      required: true,
    },
    symptoms: {
      type: String,
      required: true,
    },
    test_recommended: {
      type: String,
      required: true,
    },
    medicine_recommended: {
      type: String,
      required: true,
    },
    ayush_treatment: {
      type: String,
      required: true,
    },
  },
  { timestamps: true }
);

module.exports = mongoose.model("Diagnosi", diagnosis);
