const Member = require("../models/member");
let ejs = require("ejs");
let pdf = require("html-pdf");
let path = require("path");
const multer = require("multer");
const fileStorage = multer.diskStorage({
  destination: (req, file, cb) => {
    cb(null, "images");
  },
  filename: (req, file, cb) => {
    cb(null, new Date().toISOString() + "-" + file.originalname);
  },
});
exports.checkMember = (req, res, next) => {
  Member.findOne()
    .where("mobile")
    .equals(req.query.mobileNumber)
    .then((member) => {
      if (member) {
        res.status(200).json({ ok: "1" });
      } else {
        res.status(200).json({ ok: "0" });
      }
    })
    .catch((err) => console.log(err));
};

exports.getMember = (req, res, next) => {
  Member.findOne({
    $or: [{ mobile: req.query.mobileNumber }, { email: req.query.email }],
  })
    .then((member) => {
      res.status(200).json(member);
    })
    .catch((err) => console.log(err));
};

exports.getmemberid = (req, res, next) => {
  Member.findOne({ mobile: req.query.mobileNumber },{ _id: 1 })
    .then((member) => {
      res.status(200).json(member);
    })
    .catch((err) => console.log(err));
};



exports.memberregister = async function (req, res ,next) {
		  try {
			  let member = await Member.findOne({
            mobile: req.query.mobilenumber,
        });
      if (!member) {
			  var profileimage  = '' ;
			  var documentfiles = '';
			  let upload = await multer({ storage: fileStorage }).any();
			  let abc = await upload(req, res, function(err) {
				  console.log(req.files);
				  if(req.files != undefined){
				  Object.keys(req.files).forEach(function (key) {
				    if(req.files[key].fieldname == 'profilepicture'){
						profileimage = req.files[key].path;
					}
					else if(req.files[key].fieldname == 'document'){
						documentfiles += ','; 
						documentfiles += req.files[key].path;
					}
					console.log(documentfiles,"abcsa");
				});
				  }
				console.log(documentfiles,"abcs");
				let membersave = new Member(
        {
            name: req.query.name,
            email: req.query.email,
			mobile: req.query.mobilenumber,
			dob: req.query.dob,
			gender: req.query.gender,
			food_habit: req.query.food_habit,
			cityId: req.query.city,
			address: req.query.address,
			pincode: req.query.pincode,
			height: req.query.height,
			weight: req.query.weight,
			blood_group: req.query.blood_group,
			occupation: req.query.occupation,
			lifestyle: req.query.lifestyle,
			exercise_flag: req.query.exercise_flag,
			water_intake_daily: req.query.water_intake_daily,
			medical_history: req.query.medical_history,
			sick_frequently: req.query.sick_frequently,
			picture: profileimage,
			documentfiles: documentfiles,
			meals_per_day: req.query.meals_per_day,
			preferred_mode_of_treatment: req.query.preferred_mode_of_treatment,
			remark: req.query.remark,
			relation: "Self",
			renewalFlag: "N",
			activeFlag: "Y",
			activePlanId: "Free",
        }
    );
	membersave.save(function (err) {
        if (err) {
            return next(err);
        }
		res.status(200).json({
              message:
                "Member Created successfully" ,
            });
      
    })
			});
			
			
	
	  }else{
		  res.status(200).json({
              message:
                "Member Already Exist" ,
            });
	  }	
			
			 
			
}
		  catch (err) {
			console.log(err)
		}
		  
		  
      
};	 
