const express = require("express");
const bodyParser = require("body-parser");
const mongoose = require("mongoose");
const multer = require("multer");
const request = require('request');
var nodemailer = require('nodemailer');
// routes
const memberRoutes = require("./routes/member");
const doctorRoutes = require("./routes/doctor");
const ordersRoutes = require("./routes/orders");
const medicineRoutes = require("./routes/medicine");
const diagnoloticsRoutes = require("./routes/diagnostic");
const cartRoutes = require("./routes/cart");
const healthAssistRoutes = require("./routes/health_assist");
const diagnosisRoutes = require("./routes/diagnosis");
const specialitiesRoutes = require("./routes/specialities");
const wellnessRoutes = require("./routes/wellness");
const findingsRoutes = require("./routes/findings");
const plansRoutes = require("./routes/plans");
const healtharticleRoutes = require("./routes/healtharticle");
const homewellnessRoutes = require("./routes/homewellness");
const doctorqualificationsRoutes = require("./routes/doctorqualifications");
const providertypesRoutes = require("./routes/providertypes");
const equipmentsRoutes = require("./routes/equipments");
const healthissuesRoutes = require("./routes/healthissues");
const proceduresRoutes = require("./routes/procedures");
const symptomsRoutes = require("./routes/symptoms");
const furtherrecommendationsRoutes = require("./routes/furtherrecommendations");
const homevisitRoutes = require("./routes/homevisit");
const accrediationRoutes = require("./routes/accrediation");
const languageRoutes = require("./routes/language");
const paymenttransationsRoutes = require("./routes/paymenttransations");
const providerratesRoutes = require("./routes/providerrates");
const facilityRoutes = require("./routes/facility");
const savefacilityRoutes = require("./routes/savefacility");
const savecityRoutes = require("./routes/city");


const app = express();
//const fileStorage = multer.diskStorage({
  //destination: (req, file, cb) => {
   // cb(null, "images");
  //},
 // filename: (req, file, cb) => {
   // cb(null, new Date().toISOString() + "-" + file.originalname);
//},
//});

//app.use(multer({ storage: fileStorage }).single("image"));
app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: true }));

mongoose.set("useFindAndModify", false);

// remove CORS erros
app.use((req, res, next) => {
  res.setHeader("Access-Control-Allow-Origin", "*");
  res.setHeader(
    "Access-Control-Allow-Methods",
    "OPTIONS, GET, POST, PUT, PATCH, DELETE"
  );
  res.setHeader("Access-Control-Headers", "Content-Type", "Authorization");
  next();
});

app.use(memberRoutes);
app.use(doctorRoutes);
app.use(ordersRoutes);
app.use(medicineRoutes);
app.use(diagnoloticsRoutes); 
app.use(cartRoutes);
app.use(healthAssistRoutes);
app.use(diagnosisRoutes);
app.use(specialitiesRoutes);
app.use(wellnessRoutes);
app.use(findingsRoutes);
app.use(plansRoutes);
app.use(healtharticleRoutes);
app.use(homewellnessRoutes);
app.use(doctorqualificationsRoutes);
app.use(providertypesRoutes);
app.use(equipmentsRoutes);
app.use(healthissuesRoutes);
app.use(proceduresRoutes);
app.use(symptomsRoutes);
app.use(furtherrecommendationsRoutes);
app.use(homevisitRoutes);
app.use(accrediationRoutes);
app.use(languageRoutes);
app.use(paymenttransationsRoutes);
app.use(providerratesRoutes);
app.use(facilityRoutes);
app.use(savefacilityRoutes);
app.use(savecityRoutes);





mongoose
  .connect(
    "mongodb+srv://medico:oexUB6vZ7Zv614YI@cluster0.lhnty.mongodb.net/medico?retryWrites=true&w=majority")
  .then((result) => {
    app.listen(5000);
  })
  .catch((err) => console.log(err));
